import { ChevronLeft, ChevronRight } from "lucide-react";

interface PaginationProps {
  currentPage: number;
  lastPage: number;
  onPageChange: (page: number) => void;
}

export default function Pagination({ currentPage, lastPage, onPageChange }: PaginationProps) {
  if (lastPage <= 1) return null;

  return (
    <div className="d-flex align-items-center justify-content-between">
      <div className="small text-muted">
        Page {currentPage} of {lastPage}
      </div>
      <div className="d-flex gap-2">
        <button
          className="btn btn-sm btn-light border"
          onClick={() => onPageChange(currentPage - 1)}
          disabled={currentPage <= 1}
        >
          <ChevronLeft size={16} />
        </button>
        <button
          className="btn btn-sm btn-light border"
          onClick={() => onPageChange(currentPage + 1)}
          disabled={currentPage >= lastPage}
        >
          <ChevronRight size={16} />
        </button>
      </div>
    </div>
  );
}
