"use client";

import { Plus } from "lucide-react";
import Link from "next/link";

interface PageHeaderProps {
  title: string;
  description?: string;
  actionLabel?: string;
  actionLink?: string;
}

export default function PageHeader({ 
  title, 
  description, 
  actionLabel, 
  actionLink 
}: PageHeaderProps) {
  return (
    <div className="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-3 mb-4">
      <div>
        <h2 className="fw-bold mb-1" style={{ color: 'var(--text-color)' }}>{title}</h2>
        {description && (
          <p className="lead fs-6 mb-0" style={{ color: 'var(--muted-text)' }}>{description}</p>
        )}
      </div>
      
      {actionLabel && actionLink && (
        <Link 
          href={actionLink}
          className="btn btn-primary d-flex align-items-center gap-2 px-4 py-2 rounded-3 fw-bold border-0"
          style={{ 
            background: 'linear-gradient(135deg, #f97316 0%, #ea580c 100%)',
            boxShadow: '0 4px 12px rgba(249, 115, 22, 0.2)'
          }}
        >
          <Plus size={18} />
          {actionLabel}
        </Link>
      )}
    </div>
  );
}
