"use client";

import { useAdmin } from "@/context/AdminContext";
import { useAuth } from "@/context/AuthContext";
import AdminSidebar from "@/components/admin/AdminSidebar";
import AdminHeader from "@/components/admin/AdminHeader";
import { cn } from "@/lib/utils";
import { useRouter, usePathname } from "next/navigation";
import { useEffect } from "react";
import { Loader2 } from "lucide-react";

export default function AdminLayoutShell({
  children,
}: {
  children: React.ReactNode;
}) {
  const { sidebarOpen } = useAdmin();
  const { user, loading } = useAuth();
  const router = useRouter();
  const pathname = usePathname();

  useEffect(() => {
    if (!loading && !user) {
      router.push("/login");
    }
  }, [user, loading, router]);

  const SIDEBAR_WIDTH = sidebarOpen ? 280 : 80;

  if (loading) {
    return (
      <div className="min-h-screen d-flex align-items-center justify-content-center" style={{ backgroundColor: 'var(--bg-color)' }} suppressHydrationWarning={true}>
        <Loader2 className="animate-spin text-primary-custom" size={32} />
      </div>
    );
  }

  if (!user) {
    return null; // Will redirect
  }

  return (
    <div className="min-h-screen transition-all duration-300" style={{ backgroundColor: 'var(--bg-color)', color: 'var(--text-color)' }} suppressHydrationWarning={true}>
      <AdminSidebar width={SIDEBAR_WIDTH} collapsed={!sidebarOpen} />
      <AdminHeader leftOffset={SIDEBAR_WIDTH} />
      <main 
        style={{ 
          paddingLeft: `${SIDEBAR_WIDTH}px`, 
          paddingTop: '80px',
          minHeight: '100vh',
          transition: 'padding-left 0.3s cubic-bezier(0.4, 0, 0.2, 1)'
        }}
      >
        <div className="container-fluid px-4 pb-4">
          {children}
        </div>
      </main>
    </div>
  );
}
