"use client";

import { useAdmin } from "@/context/AdminContext";
import { Search, Bell, Settings, Menu, Sun, Moon } from "lucide-react";
import { cn } from "@/lib/utils";

export default function AdminHeader({ leftOffset = 280 }: { leftOffset?: number }) {
  const { toggleSidebar, theme, toggleTheme } = useAdmin();

  return (
    <header className="position-fixed top-0 end-0 transition-all duration-300 bg-header" style={{ 
      left: `${leftOffset}px`, 
      zIndex: 1000,
      minHeight: '80px',
      transition: 'left 0.3s cubic-bezier(0.4, 0, 0.2, 1)',
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center'
    }}>
      <div className="container-fluid h-100">
        <div className="d-flex align-items-center justify-content-between h-100 px-4 position-relative">
            {/* Left Section - Title */}
            <div className="d-flex align-items-center gap-3">
              <button 
                onClick={toggleSidebar}
                className="btn btn-link text-muted-custom p-2 rounded-3 hover:bg-black/5 dark:hover-bg-white/5"
                style={{ border: '1px solid var(--border-color)' }}
              >
                <Menu size={20} />
              </button>
              <div>
                <h4 className="mb-0 fw-bold" style={{ color: 'var(--text-color)' }}>Dashboard</h4>
                <small className="text-muted-custom">Welcome back, Admin</small>
              </div>
            </div>

            {/* Center Section - Search */}
            <div className="position-absolute top-50 start-50 translate-middle d-none d-md-block" style={{ width: '320px' }}>
              <div className="position-relative">
                <Search className="position-absolute top-50 translate-middle-y ms-3" size={18} style={{ color: 'var(--muted-text)' }} />
                <input 
                  type="text" 
                  className="form-control form-control-sm ps-5 py-2" 
                  placeholder="Quick search..."
                  style={{
                    borderRadius: '12px',
                    backgroundColor: 'var(--bg-color)',
                    borderColor: 'var(--border-color)',
                    color: 'var(--text-color)'
                  }}
                />
              </div>
            </div>

            {/* Right Section - Actions */}
            <div className="d-flex align-items-center gap-3">

            {/* Theme Toggle */}
            <button 
              onClick={toggleTheme}
              className="btn btn-sm d-flex align-items-center justify-content-center" 
              style={{
                width: '40px',
                height: '40px',
                borderRadius: '12px',
                backgroundColor: 'var(--bg-color)',
                border: '1px solid var(--border-color)',
                color: 'var(--text-color)'
              }}
            >
              {theme === 'dark' ? <Sun size={18} /> : <Moon size={18} />}
            </button>

            {/* Notifications */}
            <button className="btn btn-sm position-relative d-flex align-items-center justify-content-center" style={{
              width: '40px',
              height: '40px',
              borderRadius: '12px',
              backgroundColor: 'var(--bg-color)',
              border: '1px solid var(--border-color)',
              color: 'var(--text-color)'
            }}>
              <Bell size={18} />
              <span className="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle" style={{ width: '8px', height: '8px' }}>
                <span className="visually-hidden">New alerts</span>
              </span>
            </button>

            {/* Settings */}
            <button className="btn btn-sm d-flex align-items-center justify-content-center" style={{
              width: '40px',
              height: '40px',
              borderRadius: '12px',
              backgroundColor: 'var(--bg-color)',
              border: '1px solid var(--border-color)',
              color: 'var(--text-color)'
            }}>
              <Settings size={18} />
            </button>

            {/* Divider */}
            <div className="vr opacity-25" style={{ height: '40px' }}></div>

            {/* User Profile */}
            <div className="d-flex align-items-center gap-2">
              <div className="text-end d-none d-md-block">
                <div className="fw-semibold small" style={{ color: 'var(--text-color)' }}>Admin User</div>
                <div className="text-muted-custom" style={{ fontSize: '11px' }}>Super Admin</div>
              </div>
              <div className="rounded-3 d-flex align-items-center justify-center fw-bold text-white shadow-sm" style={{
                width: '42px',
                height: '42px',
                background: 'linear-gradient(135deg, #f97316 0%, #ea580c 100%)',
              }}>
                AD
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
  );
}
