"use client";

import { MoreVertical, Edit, Trash, Eye } from "lucide-react";
import { useState, useRef, useEffect } from "react";
import { cn } from "@/lib/utils";

interface ActionMenuProps {
  onView?: () => void;
  onEdit?: () => void;
  onDelete: () => void;
}

export default function ActionMenu({ onView, onEdit, onDelete }: ActionMenuProps) {
  const [isOpen, setIsOpen] = useState(false);
  const menuRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    const handleClickOutside = (event: MouseEvent) => {
      if (menuRef.current && !menuRef.current.contains(event.target as Node)) {
        setIsOpen(false);
      }
    };

    document.addEventListener("mousedown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, []);

  return (
    <div className="position-relative" ref={menuRef}>
      <button 
        onClick={() => setIsOpen(!isOpen)}
        className="btn btn-sm btn-link text-muted-custom p-1 rounded-circle hover-bg-custom transition-all"
        style={{ color: 'var(--muted-text)' }}
      >
        <MoreVertical size={18} />
      </button>

      {isOpen && (
        <div 
            className="position-absolute end-0 top-100 mt-1 rounded-3 shadow-lg border animate-fade-in"
            style={{ 
                zIndex: 1000, 
                minWidth: '160px',
                backgroundColor: 'var(--bg-color)',
                borderColor: 'var(--border-color)'
            }}
        >
          <div className="py-1">
             {onView && (
              <button 
                  onClick={() => {
                      onView();
                      setIsOpen(false);
                  }}
                  className="dropdown-item d-flex align-items-center gap-2 px-3 py-2 small fw-semibold transition-all"
                  style={{ color: 'var(--text-color)' }}
                  onMouseEnter={(e) => e.currentTarget.style.backgroundColor = 'var(--hover-bg)'}
                  onMouseLeave={(e) => e.currentTarget.style.backgroundColor = 'transparent'}
              >
                <Eye size={14} className="text-info" />
                View Details
              </button>
            )}
            {onEdit && (
            <button 
                onClick={() => {
                    onEdit();
                    setIsOpen(false);
                }}
                className="dropdown-item d-flex align-items-center gap-2 px-3 py-2 small fw-semibold transition-all"
                style={{ color: 'var(--text-color)' }}
                onMouseEnter={(e) => e.currentTarget.style.backgroundColor = 'var(--hover-bg)'}
                onMouseLeave={(e) => e.currentTarget.style.backgroundColor = 'transparent'}
            >
              <Edit size={14} className="text-primary-custom" />
              Edit
            </button>
            )}
            <button 
                onClick={() => {
                    onDelete();
                    setIsOpen(false);
                }}
                className="dropdown-item d-flex align-items-center gap-2 px-3 py-2 small fw-semibold transition-all text-danger"
                onMouseEnter={(e) => e.currentTarget.style.backgroundColor = 'var(--hover-bg)'}
                onMouseLeave={(e) => e.currentTarget.style.backgroundColor = 'transparent'}
            >
              <Trash size={14} />
              Delete
            </button>
          </div>
        </div>
      )}
    </div>
  );
}
