"use client";

import PageHeader from "@/components/admin/PageHeader";
import { DollarSign, TrendingUp, CreditCard, Wallet, Download } from "lucide-react";

export default function AdminFinancePage() {
  return (
    <div className="py-2">
      <div className="d-flex justify-content-between align-items-end mb-4">
        <PageHeader 
            title="Finance Overview" 
            description="Track revenue, withdrawals, and platform earnings."
        />
        <button className="btn btn-outline-secondary d-flex align-items-center gap-2 rounded-3 fw-bold border-2"
          style={{ borderColor: 'var(--border-color)', color: 'var(--text-color)' }}
        >
            <Download size={18} />
            Export Report
        </button>
      </div>

      {/* Stats Cards */}
      <div className="row g-4 mb-4">
        <div className="col-12 col-md-4">
           <div className="card-custom p-4 d-flex flex-column h-100 position-relative overflow-hidden">
               <div className="position-absolute top-0 end-0 p-4 opacity-10">
                   <DollarSign size={80} />
               </div>
               <p className="small text-muted-custom fw-bold text-uppercase mb-1">Total Revenue</p>
               <h2 className="fw-bold mb-0" style={{ color: 'var(--text-color)' }}>$124,500.00</h2>
               <div className="mt-auto pt-3 d-flex align-items-center gap-1 text-success fw-bold small">
                   <TrendingUp size={16} />
                   <span>+12.5% from last month</span>
               </div>
           </div>
        </div>
         <div className="col-12 col-md-4">
           <div className="card-custom p-4 d-flex flex-column h-100 position-relative overflow-hidden">
               <div className="position-absolute top-0 end-0 p-4 opacity-10">
                   <Wallet size={80} />
               </div>
               <p className="small text-muted-custom fw-bold text-uppercase mb-1">Pending Withdrawals</p>
               <h2 className="fw-bold mb-0" style={{ color: 'var(--text-color)' }}>$4,250.00</h2>
               <div className="mt-auto pt-3 d-flex align-items-center gap-1 text-warning fw-bold small">
                   <span>15 requests pending</span>
               </div>
           </div>
        </div>
         <div className="col-12 col-md-4">
           <div className="card-custom p-4 d-flex flex-column h-100 position-relative overflow-hidden">
               <div className="position-absolute top-0 end-0 p-4 opacity-10">
                   <CreditCard size={80} />
               </div>
               <p className="small text-muted-custom fw-bold text-uppercase mb-1">Net Profit</p>
               <h2 className="fw-bold mb-0" style={{ color: 'var(--text-color)' }}>$12,450.00</h2>
               <div className="mt-auto pt-3 d-flex align-items-center gap-1 text-success fw-bold small">
                   <TrendingUp size={16} />
                   <span>+8.2% growth</span>
               </div>
           </div>
        </div>
      </div>

      {/* Recent Transactions */}
      <h5 className="fw-bold mb-3 mt-5" style={{ color: 'var(--text-color)' }}>Recent Transactions</h5>
      <div className="card-custom overflow-hidden">
          <div className="table-responsive">
          <table className="table mb-0 align-middle">
            <thead style={{ backgroundColor: 'var(--hover-bg)' }}>
              <tr>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom" style={{ borderColor: 'var(--border-color)' }}>Transaction ID</th>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom" style={{ borderColor: 'var(--border-color)' }}>User / Store</th>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom" style={{ borderColor: 'var(--border-color)' }}>Type</th>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom" style={{ borderColor: 'var(--border-color)' }}>Date</th>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom text-end" style={{ borderColor: 'var(--border-color)' }}>Amount</th>
                <th className="px-4 py-3 small text-uppercase text-muted-custom border-bottom text-end" style={{ borderColor: 'var(--border-color)' }}>Status</th>
              </tr>
            </thead>
            <tbody>
              {[1, 2, 3, 4, 5].map((i) => (
                <tr key={i} style={{ borderBottom: '1px solid var(--border-color)' }}>
                  <td className="px-4 py-3 small text-muted-custom">#TRX-8823{i}</td>
                  <td className="px-4 py-3 fw-semibold text-color-custom">Burger Queen Head Office</td>
                  <td className="px-4 py-3 small text-color-custom">Payout Withdrawal</td>
                  <td className="px-4 py-3 small text-muted-custom">Oct 24, 2023</td>
                  <td className="px-4 py-3 text-end fw-bold text-danger">-$1,200.00</td>
                   <td className="px-4 py-3 text-end">
                    <span className="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 rounded-pill">Completed</span>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </div>
    </div>
  );
}
